Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[mission1.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.5,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 8.0,
		DefaultHiveTowerCount = 8,
	},
	Rules = 
	{
		--AutoCapture 	= true,		--Destroying hives automatically counts as a capture
		--NoPushback		= true,		--Can the player's points be captured?
		WeakenHiveOnCap = true,         --Do captures halve defensive strength?
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 4,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
		    [[ZU_SPAWN_BRUTES]],
		    [[ZU_NONE]],
            [[ZU_TOWER_CARAPACE]],
            [[ZU_NONE]], 
			[[ZU_BONE_SHIELD]],
			[[ZU_NONE]],
            [[ZU_DEATH_BONES]],	
	
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
		},	
		Locked =
		{
		},			
	},
	
	OnLevelReward = nil,
	
	OnDebugCall = function (mousePos)

        SpawnBossHiveDefenses()
        StartBossAirstrikes()

	end
}

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		CaptureAllObjective:Enable()
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Destroy all the enemy points")
		
		local text_hdl = GameWorld:ShowText("Slash and burn team\nWe're going to clear out the normal hives.\n\nThen we go for the big one down there.", "Sarge")
		ScriptMgr:DoDelayedCall(16000, function () text_hdl:ClearText(); end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		KillBossObjective:Enable()
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()

local hiveBossDefenseEnts = {}
function SpawnBossHiveDefenses()
    for i=1, 3 do
        local entId = "hiveSpawnArea" .. i
        local spawnLoc = GameWorld:GetEntityById(entId)
        local hiveIndex = i
        
        if spawnLoc then
            local spawnPos = spawnLoc:GetPos()
            ScriptMgr:DoDelayedCall(1000*i,
                function ()
                    if hiveBossDefenseEnts[hiveIndex] and not hiveBossDefenseEnts[hiveIndex]:GetPtr() then
                        hiveBossDefenseEnts[hiveIndex] = nil
                    end

                    if hiveBossDefenseEnts[hiveIndex] == nil then
                        hiveBossDefenseEnts[hiveIndex] = GameWorld:SpawnHive(spawnPos):GetHandle()
                    end
                end)
        end	
    end
end

------------------------------------------------------------------------------- Kill the Boss hive objective
KillBossObjective = LevelUtils.MakeGoal(
	function (self)
        LevelUtils.ShowTimedDialogue("The big hive is vulnerable, commander\n\nConcentrated fire should take it down.", "Scout")     
        
	    GameWorld:AddObjective("bossObj", "Kill the giant hive")
	    
                         
	    ScriptMgr:DoDelayedCall(200, 	function ()
	                                        UpdateBossHP()
	                                        return true
                                        end)
                                        
        --HP triggers for boss hive
        local boss = GameWorld:GetEntityById("bossHive")
        if boss then
            boss:SetDamageResistance(0.75)
            boss:SetDefensiveSpawn(CHiveBoss.ST_ZOMBIE)
        end
        
        local bossHandle = boss:GetHandle()
        LevelUtils.CreateEntityHPMonitor(bossHandle, {0.75, 0.5, 0.25},
            function (p_hpFract)
                if p_hpFract == 0.75 then
                    LevelUtils.ShowTimedDialogue("Dammit General, we need some backup here!", "Sarge")
                    
                    for i=1, 3 do
                        local entId = "ammoDropArea" .. i
                        local spawnLoc = GameWorld:GetEntityById(entId)
                        
                        if spawnLoc then
                            local spawnPos = spawnLoc:GetPos()
                            ScriptMgr:DoDelayedCall(1500*i,
                                function ()
                                    local chopper = GameWorld:SpawnChopper(vect2f(0.3, 1.0), spawnPos)
			                        chopper:SetMission(ChopperOrder.CO_DELIVERY, spawnPos, "AmmoCrates")
                                end)
                        end	
                    end
                    
                    local bossEnt = bossHandle:GetPtr()
                    if bossEnt then
                        SpawnBossHiveDefenses()
                    end
                   
                    ScriptMgr:DoDelayedCall(10000,
                        function ()
                            LevelUtils.ShowTimedDialogue("Alpha Wing\n\nCommence rolling airstrikes on the target!", "General") 
                            StartBossAirstrikes()
                        end)
                end
                --[[
                local ent = bossHandle:GetPtr()
                if ent then
                    local boss = ent:ToCHiveBoss()
                    if boss then
                        boss:LockMaxHPFraction(p_hpFract)
                    end
                end
                --]]
            end)                       
                                                                    
        bossShouldBeInvulnerable = false
        
        LevelUtils.CreateEntityHPMonitor(bossHandle, {0.8, 0.6, 0.4, 0.2},
            function (p_hpFract)
                local bossEnt = bossHandle:GetPtr()
                if bossEnt then
                    bossEnt:LockMaxHPFraction(p_hpFract)
                end
            end)
    end,
	
	{[[NT_ENTITY_DESTROYED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
        if p_entId ~= "bossHive" then
            return
        end

        GameWorld:ChangeObjectiveStatus("bossObj", [[complete]])

        local text_hdl = GameWorld:ShowText("Yes!\n\nWar is intellect - an alien mass of flesh in no match for this army!", "General")
		ScriptMgr:DoDelayedCall(8000,
            function()
                GameWorld:GameOver(true)
                GameWorld:ClearText()
            end)	
	end,
	
	function (self)
	end)


-- Do a single airstrike
function DoAirstrike(p_bossPos)
    local dir = vect2f(1.0, 0.0)
    dir:Rotate(GetRandomRange(0.0, math.pi*2))
   
    local chopper = GameWorld:SpawnChopper(dir, p_bossPos)
    --if GetRandomBool(0.2) then
     --   chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_MISSILE, p_bossPos, "")
    --else
    --    chopper:SetAmmoK(3.0)
    --    chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_CANNON, p_bossPos, "")
    --end
    
    chopper:SetMission(ChopperOrder.CO_AIRSTRIKE_MISSILE, p_bossPos, "")
end

-- Do airstrikes in a loop
function StartBossAirstrikes()

    ScriptMgr:DoDelayedCall(5000, 	
        function ()

            local filteredEntList = {}
            for i=1, #hiveBossDefenseEnts do
                if hiveBossDefenseEnts[i] then
                    local entPtr = hiveBossDefenseEnts[i]:GetPtr()
                    if entPtr then table.insert(filteredEntList, entPtr) end
                end
            end

            if #filteredEntList > 0 then
                local strikeTgt = filteredEntList[GetRandomRangeInt(1, #filteredEntList)] --GameWorld:GetEntityById("bossHive")
                local targetPos = strikeTgt:GetPos()   

                DoAirstrike(targetPos)
            end
            return true
        end)
 
end

-- Update the big HP display
function UpdateBossHP()

    local boss = GameWorld:GetEntityById("bossHive")
    local bossHpPct = 0
    if boss then
        bossHpPct = boss:GetHPFraction() * 100  
    end

    GameWorld:SetEventIndicator(string.format("%d%% Lifeform Integrity", bossHpPct))

end

-- Apply invulnerability to the boss hive if flag is on
bossShouldBeInvulnerable = true
function OnUpdate(p_milliseconds)

    local boss = GameWorld:GetEntityById("bossHive")
    if boss then
        boss:SetGodMode(bossShouldBeInvulnerable)
    end
    
end
ScriptMgr:SetUpdateCallback(OnUpdate)




------------------------------------------------------------------------------- Mutation happened - send a crate!
HelpCrateTrigger = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:AddObjective("crateObj", "Pick up the flamethrower crate")
		CratePickupGoal:Enable()
		
		GameWorld:ShowText("What the heck was that!?\nThere's some sort of new bug round here!\n\nThat's it - I'm callin for some heavy weapons", "Sarge")
	
		local crateArea = GameWorld:GetEntityById("crateArea");
		if crateArea then
			GameWorld:DoChopperDelivery(crateArea:GetPos(), "WeaponCrates")
		end
	
		self:Disable()
	end)
HelpCrateTrigger:Enable()

CrateDrop = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "WeaponCrates" then
			return
		end
		
		local ent = GameWorld:CreateEntity("WeaponCrate:WT_FLAMETHROWER", "flameCrate", p_pos)
		GameWorld:CreateTrainingArrow(ent)
		
		local ent = GameWorld:CreateEntity("WeaponCrate:WT_MEDIC", "", p_pos + vect2f(5,0))
		GameWorld:CreateTrainingArrow(ent)	
	
		GameWorld:ShowText("Christmas is early this year\nSanta got us a FL-375 portable flamethrower!\n\nLet's run over to the crates and try it out", "Sarge");
	
		self:Disable()
	end)
CrateDrop:Enable()

CratePickupGoal = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_POWERUP_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_entId ~= "flameCrate" then
			return
		end
		
		GameWorld:ChangeObjectiveStatus("crateObj", [[complete]])
		
		local text_hdl = GameWorld:ShowText("Barbecue time!\n\nBet you that this baby will blow through that gunk easy", "Sarge")
		ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)	
	
		self:Disable()
	end)
		
------------------------------------------------------------------------------- Chopper Delivery (Ammo)
CrateDropAmmo = LevelUtils.MakeGoal(
	function (self)	
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "AmmoCrates" then
			return
		end
		
		local crate1 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(3.5,0))
		local crate2 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,3.5))
		local crate3 = GameWorld:CreateEntity("AmmoCrate", "", p_pos + vect2f(-3.5,-3.5))
			
		--self:Disable()
	end)
CrateDropAmmo:Enable()